/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.store;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import cz.insophy.inplan.plan.ActionActivity;
import cz.insophy.inplan.plan.Activity;
import cz.insophy.inplan.plan.RebuildActivity;
import cz.insophy.inplan.shop.Action;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.shop.MaterialQuantity;
import cz.insophy.inplan.shop.RebuildType;
import cz.insophy.inplan.store.InPlanPtnStoreActivity;
import cz.insophy.inplan.store.InPlanRebuildStoreActivity;
import cz.insophy.inplan.store.StoreActivityOwner;
import cz.insophy.inplan.store.StoreType;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import cz.insophy.inplan.util.Tuple;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StoreActivityFactory {
    private static final Logger log = LoggerFactory.getLogger(StoreActivityFactory.class);
    private static final Comparator<Tuple<Long, Double>> TUPLE_TIME_COMPARATOR = new Comparator<Tuple<Long, Double>>(){

        @Override
        public int compare(Tuple<Long, Double> o1, Tuple<Long, Double> o2) {
            return Long.compare(o1.getFirst(), o2.getFirst());
        }
    };

    private StoreActivityFactory() {
    }

    private static List<InPlanPtnStoreActivity> createStoreActivitiesOld(Action action, StoreActivityOwner owner, double requestedQtyMat, double requestedQtyProd, long allocTime, long layInTime, StoreType storeType) {
        List<MaterialQuantity> matQs = action.getBom() != null ? action.getBom().ingredients() : Collections.emptyList();
        List<MaterialQuantity> prodQs = action.getProduces();
        ArrayList<InPlanPtnStoreActivity> resultSas = Lists.newArrayListWithExpectedSize(matQs.size() + prodQs.size());
        if (requestedQtyMat > 0.0) {
            for (MaterialQuantity mq : matQs) {
                Material m3 = mq.getMaterial();
                double saQty = (m3.isConstant() ? 1.0 : requestedQtyMat) * mq.getQty();
                if (saQty == 0.0) continue;
                if (m3.isConsumed()) {
                    resultSas.add(new InPlanPtnStoreActivity(storeType, allocTime, m3, -saQty, owner));
                    continue;
                }
                if (allocTime == layInTime) continue;
                resultSas.add(new InPlanPtnStoreActivity(storeType, allocTime, m3, -saQty, owner));
                resultSas.add(new InPlanPtnStoreActivity(storeType, layInTime, m3, saQty, owner));
            }
        }
        if (requestedQtyProd > 0.0) {
            for (MaterialQuantity pi : prodQs) {
                double saQty = requestedQtyProd * pi.getQty();
                if (saQty == 0.0) continue;
                resultSas.add(new InPlanPtnStoreActivity(storeType, layInTime, pi.getMaterial(), saQty, owner));
            }
        }
        return resultSas;
    }

    public static List<InPlanPtnStoreActivity> createStoreActivities(ActionActivity aa) {
        if (aa.getGar() == null) {
            return StoreActivityFactory.createStoreActivitiesOld(aa.getAction(), aa, aa.getQty(), aa.getQty(), aa.getStart(), aa.getEnd(), StoreType.INPLAN_ACTUAL);
        }
        return Collections.emptyList();
    }

    public static List<InPlanPtnStoreActivity> createStoreActivities(GeneralizedActionRequest gar) {
        List<InPlanPtnStoreActivity> res = gar.getOutOfPlanQty() - gar.getOutOfPlanMat() > 0.0 ? StoreActivityFactory.createStoreActivities(gar, gar.getAction(), gar, gar.getOutOfPlanQty() - gar.getOutOfPlanMat(), 0.0, gar.getReleaseDate(), gar.getReleaseDate(), StoreType.INPLAN_ACTUAL, true) : Lists.newArrayList();
        double qty = 0.0;
        for (ActionActivity aa : gar.getActivities()) {
            qty += aa.getQty();
        }
        res.addAll(StoreActivityFactory.createStoreActivities(gar, gar.getAction(), gar, qty, qty, gar.getReleaseDate(), gar.getReleaseDate(), StoreType.INPLAN_ACTUAL, false));
        return res;
    }

    public static List<InPlanPtnStoreActivity> createStoreActivities(GeneralizedOrderRequest gor) {
        ArrayList<InPlanPtnStoreActivity> sas = Lists.newArrayList();
        if (!gor.hasSelectedActiongram()) {
            return sas;
        }
        for (GeneralizedActionRequest gar : gor.getGars()) {
            Action act = gar.getAction();
            double requestedQty = act.computeRequestedQty(gor.getRequestedQty());
            sas.addAll(StoreActivityFactory.createStoreActivities(null, gar.getAction(), gor, requestedQty - gar.getOutOfPlanMat(), requestedQty - gar.getOutOfPlanQty(), GeneralizedRequest.isDateValid(gar.getLatestPossibleStart()) ? gar.getLatestPossibleStart() : gor.getReleaseDate(), gor.getDueDate(), StoreType.INPLAN_POSSIBLE, false));
        }
        return sas;
    }

    private static List<InPlanPtnStoreActivity> createStoreActivities(GeneralizedActionRequest gar, Action action, final StoreActivityOwner owner, double requestedQtyMat, double requestedQtyProd, long allocTime, long layInTime, final StoreType storeType, boolean outOfPlan) {
        List<MaterialQuantity> matQs = action.getBom() != null ? action.getBom().ingredients() : Collections.emptyList();
        List<MaterialQuantity> prodQs = action.getProduces();
        ArrayList<InPlanPtnStoreActivity> resultSas = Lists.newArrayListWithExpectedSize(matQs.size() + prodQs.size());
        if (requestedQtyMat > 0.0) {
            for (MaterialQuantity mq : matQs) {
                List<Tuple<Long, Double>> timesQties;
                final Material m3 = mq.getMaterial();
                double saQty = (m3.isConstant() ? 1.0 : requestedQtyMat) * mq.getQty();
                if (saQty == 0.0) continue;
                if (gar == null || gar.getActivities().isEmpty() || outOfPlan) {
                    if (m3.isConsumed()) {
                        resultSas.add(new InPlanPtnStoreActivity(storeType, allocTime, m3, -saQty, owner));
                        continue;
                    }
                    if (allocTime == layInTime) continue;
                    resultSas.add(new InPlanPtnStoreActivity(storeType, allocTime, m3, -saQty, owner));
                    resultSas.add(new InPlanPtnStoreActivity(storeType, layInTime, m3, saQty, owner));
                    continue;
                }
                if (m3.isConsumed()) {
                    timesQties = StoreActivityFactory.batchize(gar, allocTime, mq.getQty(), m3.isConstant(), m3.isConsumed(), mq.getBatch(), -saQty, true);
                    resultSas.addAll(Collections2.transform(timesQties, new Function<Tuple<Long, Double>, InPlanPtnStoreActivity>(){

                        @Override
                        @Nullable
                        public InPlanPtnStoreActivity apply(@Nullable Tuple<Long, Double> input) {
                            return new InPlanPtnStoreActivity(storeType, input.getFirst(), m3, input.getSecond(), owner);
                        }
                    }));
                    continue;
                }
                timesQties = StoreActivityFactory.batchize(gar, allocTime, mq.getQty(), m3.isConstant(), m3.isConsumed(), mq.getBatch(), -saQty, true);
                timesQties.addAll(StoreActivityFactory.batchize(gar, layInTime, mq.getQty(), m3.isConstant(), m3.isConsumed(), mq.getBatch(), saQty, false));
                timesQties = StoreActivityFactory.group(timesQties);
                resultSas.addAll(Collections2.transform(timesQties, new Function<Tuple<Long, Double>, InPlanPtnStoreActivity>(){

                    @Override
                    @Nullable
                    public InPlanPtnStoreActivity apply(@Nullable Tuple<Long, Double> input) {
                        return new InPlanPtnStoreActivity(storeType, input.getFirst(), m3, input.getSecond(), owner);
                    }
                }));
            }
        }
        if (requestedQtyProd > 0.0) {
            for (final MaterialQuantity pi : prodQs) {
                double saQty = requestedQtyProd * pi.getQty();
                if (saQty == 0.0) continue;
                if (gar == null || outOfPlan) {
                    resultSas.add(new InPlanPtnStoreActivity(storeType, layInTime, pi.getMaterial(), saQty, owner));
                    continue;
                }
                List<Tuple<Long, Double>> timesQties = StoreActivityFactory.batchize(gar, layInTime, pi.getQty(), false, true, pi.getBatch(), saQty, false);
                resultSas.addAll(Collections2.transform(StoreActivityFactory.group(timesQties), new Function<Tuple<Long, Double>, InPlanPtnStoreActivity>(){

                    @Override
                    @Nullable
                    public InPlanPtnStoreActivity apply(@Nullable Tuple<Long, Double> input) {
                        return new InPlanPtnStoreActivity(storeType, input.getFirst(), pi.getMaterial(), input.getSecond(), owner);
                    }
                }));
            }
        }
        return resultSas;
    }

    @Nonnull
    private static List<Tuple<Long, Double>> batchize(GeneralizedActionRequest gar, long time, double materialQty, boolean constant, boolean consumed, double materialBatch, double saQty, boolean consuming) {
        Preconditions.checkArgument(!consuming || !constant && consumed || materialBatch <= 1.0E-7, "Positive material batch is invalid for constant or not-consumed materials.");
        double sgn = Math.signum(saQty);
        saQty = Math.abs(saQty);
        ArrayList<Tuple<Long, Double>> timesQties = Lists.newArrayList();
        if (Math.abs(materialBatch) < 1.0E-7) {
            for (ActionActivity aa : gar.getActivities()) {
                double d = constant ? 1.0 : aa.getQty();
                if (!(Math.abs(d * materialQty) > 0.0) || aa.getPlan() == null) continue;
                time = !consuming ? aa.getEnd() : aa.getStart();
                timesQties.add(Tuple.create(time, (constant ? 1.0 : aa.getQty()) * materialQty * sgn));
            }
        } else if (materialBatch > 0.0) {
            ActionActivity currAA = StoreActivityFactory.getFirstAA(gar);
            long aaTime = currAA.getEnd() - currAA.getStart();
            double aaQty = currAA.getQty() * materialQty;
            long unitLength = (long)((double)aaTime / aaQty);
            long batchTime = (long)((double)unitLength * materialBatch);
            long offset = 0L;
            double totalRemainingQty = saQty;
            double aaRemainingQty = aaQty;
            int batchNo = 0;
            while (totalRemainingQty > 1.0E-7) {
                if (materialBatch <= aaRemainingQty) {
                    time = consuming ? currAA.getStart() + batchTime * (long)batchNo + offset : currAA.getStart() + batchTime * (long)(batchNo + 1) + offset;
                    timesQties.add(Tuple.create(time, materialBatch * sgn));
                    aaRemainingQty -= materialBatch;
                    totalRemainingQty -= materialBatch;
                    ++batchNo;
                    continue;
                }
                if (materialBatch <= totalRemainingQty) {
                    if (consuming) {
                        time = currAA.getStart() + batchTime * (long)batchNo + offset;
                        timesQties.add(Tuple.create(time, materialBatch * sgn));
                    }
                    double overshootQty = materialBatch - aaRemainingQty;
                    if ((currAA = StoreActivityFactory.getNextAA(currAA, gar)) == null) {
                        throw new IllegalStateException();
                    }
                    aaQty = currAA.getQty() * materialQty;
                    aaTime = currAA.getEnd() - currAA.getStart();
                    unitLength = (long)((double)aaTime / aaQty);
                    batchTime = (long)((double)unitLength * materialBatch);
                    offset = (long)((double)unitLength * overshootQty);
                    aaRemainingQty += aaQty;
                    batchNo = -1;
                    if (!consuming) {
                        time = currAA.getStart() + batchTime * (long)(batchNo + 1) + offset;
                        timesQties.add(Tuple.create(time, materialBatch * sgn));
                    }
                    aaRemainingQty -= materialBatch;
                    totalRemainingQty -= materialBatch;
                    ++batchNo;
                    continue;
                }
                if (consuming) {
                    time = currAA.getStart() + batchTime * (long)batchNo + offset;
                } else {
                    time = currAA.getEnd();
                    ActionActivity nextAA = StoreActivityFactory.getNextAA(currAA, gar);
                    if (nextAA != null) {
                        currAA = nextAA;
                        continue;
                    }
                }
                timesQties.add(Tuple.create(time, totalRemainingQty * sgn));
                totalRemainingQty = 0.0;
                aaRemainingQty = 0.0;
            }
        } else if (materialBatch < 0.0) {
            if (consuming) {
                ActionActivity firstAA = StoreActivityFactory.getFirstAA(gar);
                if (firstAA != null) {
                    time = firstAA.getStart();
                } else {
                    log.warn("First action activity not found.");
                }
            } else {
                ActionActivity lastAA = StoreActivityFactory.getLastAA(gar);
                if (lastAA != null) {
                    time = lastAA.getEnd();
                } else {
                    log.warn("Last action activity not found.");
                }
            }
            timesQties.add(Tuple.create(time, saQty * sgn));
        } else {
            throw new IllegalStateException();
        }
        return timesQties;
    }

    private static ActionActivity getNextAA(ActionActivity currAA, GeneralizedActionRequest gar) {
        Activity retVal = null;
        for (ActionActivity aa : gar.getActivities()) {
            if (aa.getStart() <= currAA.getStart() || retVal != null && retVal.getStart() <= aa.getStart()) continue;
            retVal = aa;
        }
        return retVal;
    }

    private static ActionActivity getLastAA(GeneralizedActionRequest gar) {
        Activity lastAA = null;
        for (ActionActivity aa : gar.getActivities()) {
            if (lastAA != null && lastAA.getEnd() >= aa.getEnd()) continue;
            lastAA = aa;
        }
        return lastAA;
    }

    private static ActionActivity getFirstAA(GeneralizedActionRequest gar) {
        Activity firstAA = null;
        for (ActionActivity aa : gar.getActivities()) {
            if (firstAA != null && firstAA.getStart() <= aa.getStart()) continue;
            firstAA = aa;
        }
        return firstAA;
    }

    public static List<InPlanRebuildStoreActivity> createStoreActivities(RebuildActivity rebuildActivity) {
        List<InPlanRebuildStoreActivity> res;
        RebuildType toType = rebuildActivity.getToType();
        if (toType != null) {
            long start = rebuildActivity.getStart();
            long end = rebuildActivity.getEnd();
            res = Lists.newArrayList();
            for (MaterialQuantity mq : toType.getBom()) {
                Material m3 = mq.getMaterial();
                res.add(new InPlanRebuildStoreActivity(start, m3, -mq.getQty(), rebuildActivity));
                if (m3.isConsumed()) continue;
                res.add(new InPlanRebuildStoreActivity(end, m3, mq.getQty(), rebuildActivity));
            }
        } else {
            res = Collections.emptyList();
        }
        return res;
    }

    @VisibleForTesting
    static List<Tuple<Long, Double>> group(List<Tuple<Long, Double>> evts) {
        if (evts.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Tuple<Long, Double>> res = Lists.newArrayListWithCapacity(evts.size());
        for (Tuple<Long, Double> evt : evts) {
            int idx = Collections.binarySearch(res, evt, TUPLE_TIME_COMPARATOR);
            if (idx >= 0) {
                double qty = evt.getSecond() + (Double)((Tuple)res.get(idx)).getSecond();
                if (Math.abs(qty) > 1.0E-7) {
                    res.set(idx, Tuple.create(evt.getFirst(), qty));
                    continue;
                }
                res.remove(idx);
                continue;
            }
            res.add(-(idx + 1), evt);
        }
        return res;
    }
}

